#!/bin/bash
# (c) Pieter E Smit 2018 - GPL-3
# 1. Expects S1="config" that gets sourced into env.
# 2. Confirms list of variables exist
required_vars=" CH CHANNELTAG SP_DEPLOY_ID SP_DEPLOY_SECRET SP_K8S_ID SP_K8S_SECRET TENANT SUBSCRIPTIONID AKSENVIRONMENT AKSCLUSTERNAME AKSCLUSTERNODECOUNT AKSCLUSTERADDONS RESOURCELOCATION"
# 3. loops through other's az_script-??-*.sh one by one

starttime=$(date +%s)
echo "#$0: START - $(env TZ=Pacific/Auckland date -Is)  /  $(env TZ=UTC date -Is)"

#Get path for this script base path readlink="resolved symbolic links"
path_script="$(readlink -f "$0")"
path_script="${path_script%/*}"

config="$1"
if [ -z "$config" ]; then
    echo "# No config file provided on commandline to $0 ?"
    exit 1
fi

#Check if we can find config file
path_conf="$path_script"
if [ -f "$path_conf/$config" ]; then
    echo "#$0: $path_conf/$config found proceeding."
else
    path_conf="$path_script/k8sConfigs"
    if [ -f "$path_conf/$config" ]; then
      echo "#$0: $path_conf/$config found proceeding."
    else
      echo "#$0: Error !! missing $config"
      echo
      echo "#    debug: ls $path_conf"
      ls -l $path_conf
      echo
      echo "#    debug: ls $path_script"
      ls -l $path_script
      exit 1
    fi

fi

source $path_conf/$config
echo "### sourced config from [$path_conf/$config]"

#Add second config file for local credential loading
if [ -f "$2" ]; then
  configsecond="$2"
  source "$2"
  echo "### sourced 2nd config from [$2]"
  echo "# PESDEBUG=$PESDEBUG"
  echo
else
  configsecond=""
fi

# check the resouces availability from az pipeline
varsok="0"

for resource in ${required_vars} ;
do
  if [ -z "${!resource}" ]; then
    echo "  [$resource] Not found from ENV or config $config. Check pipeline variables"
    varsok="1"
    # Exit at end of loop: exit 1;
  fi
done
if [ "$varsok" -eq "1" ]; then
    echo
    echo "Exit script $0 missing config ..."
    exit 1
fi

trapexit () {
  set +x
  echo "############      ^^ Look for error above here ^^       ############"
  if [[ "$DebugDeleteKubeConf" != false ]]; then
  echo "############ !!!!!!!!!!!!!!  Cleaning UP !!!!!!!!!!!!!! ############" >&2
    # clean up credentials when unexpected exits.
    bash $path_script/az_script-99-cleanup.sh
  else
    echo "Skip az_script-99-cleanup.sh DebugDeleteKubeConf=\"$DebugDeleteKubeConf\" "
  fi
  echo "####################################################################" >&2
  echo "EXIT caught from az script! ${f##*/}" >&2
  echo "The End $(env TZ=Pacific/Auckland date -Is)  /  $(env TZ=UTC date -Is)"
  echo "Run time $(( $( date +%s ) - $starttime ))sec"
  echo "####################################################################" >&2
  trap '' exit
  exit 1
}
trap trapexit exit

#Run all scripts
for f in $path_script/az_script-??-*.sh;
  do
    scripttime=$(date +%s)
    set +x
    echo
    echo "####################################################################"
    echo "# Run deployment script: "
    echo "# script: $f "
    echo "# conf  : $path_conf/$config"
    echo "####################################################################"
    echo
    ## enable debug
    # set -x
    time bash "$f" "$path_conf/$config" "$configsecond"
    rc=$?
    if [ $rc -ne 0 ]; then
        exit $rc
    fi
    echo "# done: ${f##*/} finished in $(( $( date +%s ) - $scripttime ))sec total=$(( $( date +%s ) - $starttime ))sec"
    echo "####################################################################"
    # Or more explicitly: if this execution fails, then stop the `for`:
    # if ! bash "$f" -H; then break; fi
  done

echo "#$0: The End $(env TZ=Pacific/Auckland date -Is)  /  $(env TZ=UTC date -Is)"
echo "#az-pipeline-run-all.sh  Run time $(( $( date +%s ) - $starttime ))sec"
trap - exit
exit 0
